REM Text Watermark.CSC v1.2 from AntiPoetics.com
REM Copyright  2006-2010 James Aswell

Dim TextString As String
Dim FontName As String, TypeSize As String, FillColor As String
Dim AlignH As Long, AlignV As Long, OffsetX As Long, OffsetY As Long
Dim Opacity As Long, MergeMode As Long, Flatten As Boolean

On Error Resume Next

'User Settings:
'#########################################################
'Watermark text, ex. "Testing..."
'if blank, you will be prompted for it
TextString = ""

'Name of Font for text, ex. "Arial"
FontName = "Arial"

'Point size for text, ex. "12.000"
TypeSize = "12.000"

'Fill color for text ex. "R,G,B"
FillColor = "0,0,0"

'Text horizontal alignment: 1 = Left, 2 = Right, 3 = Center
AlignH = 2

'Text vertical alignment: 1 = Top, 2 = Bottom, 3 = Center
AlignV = 2

'Move Text on the X axis, ex. -10
OffsetX = -10

'Move Text on the Y axis, ex. -10
OffsetY = -10

'Opacity: 100 ... 0
Opacity = 100

'Object Merge Mode:
MergeMode = 0
	'0 = Normal
	'1 = Add
	'2 = Subtract
	'3 = Difference
	'4 = Multiply
	'5 = Divide
	'6 = If Lighter
	'7 = If Darker
	'8 = Texturize
	'9 = Color
	'10 = Hue
	'11 = Saturation
	'12 = Lightness
	'13 = Invert
	'14 = Logical AND
	'15 = Logical OR
	'16 = Logical XOR
	'17 = Behind
	'18 = Screen
	'19 = Overlay
	'20 = Soft Light
	'21 = Hard Light
	'22 = Color Dodge
	'23 = Color Burn

'Flatten document: False, True
Flatten = False

'#########################################################

WITHOBJECT "CorelPHOTOPAINT.Automation.12"

	If TextString = "" Then TextString = InputBox("Enter your watermark text.")
	If TextString = "" Then GoTo ScriptEnd

	'output FileName text
	.TextTool 10, 10, FALSE, TRUE, 0
		.TextSetting "Fill", FillColor
		.TextSetting "Font", FontName
		.TextSetting "TypeSize", TypeSize
		.TextSetting "Direction", "0"
		.TextAppend TextString
		.TextRender 

	'align object
	.ObjectAlign AlignH, AlignV, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, 0, 0
		.EndObject 

	'move object to final location
	.ObjectTranslate OffsetX, OffsetY, FALSE
		.EndObject

	'set object opacity
	.ObjectOpacity Opacity
		.EndObject 

	.ObjectMergeMode MergeMode
		.EndObject

	If Flatten = True Then
		.ObjectMerge TRUE
			.EndObject 
	End If

ScriptEnd:	
END WITHOBJECT
